﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Managers;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis.UserInterface
{
    public class StageUI : UI
    {
        UIText scoreText;
        UIText timeText;

        public StageUI(Game game)
            :base(game)
        {
            FontManager fontManager = CashierGame.Instance.Services.GetService(typeof(FontManager)) as FontManager;
            SpriteFont font = fontManager.GetFont("Default");

            scoreText = new UIText("0");
            scoreText.Font = font;
            scoreText.Position = new Vector2(SceneManager.CenterAlign, 16);

            timeText = new UIText("5:00");
            timeText.Font = font;
            timeText.Position = new Vector2(SceneManager.CenterAlign + 100, 16);

            AddWidget(scoreText);
            AddWidget(timeText);
        }

        public override void Draw(SpriteBatch spriteBatch)
        {
            base.Draw(spriteBatch);
        }

        public override void Update(GameTime gameTime)
        {
            base.Update(gameTime);
        }

        public void UpdateScore(int score)
        {
            scoreText.Text = score.ToString();
        }
    }
}
